//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.ui.components](index.md)/[UserSelect](-user-select.md)

# UserSelect

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [UserSelect](-user-select.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, selectedUsers: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[User](../ai.botstacks.sdk.state/-user/index.md)&gt;, canRemove: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, showAdd: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = true, onRemove: ([User](../ai.botstacks.sdk.state/-user/index.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { }, onAddSelected: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { })

UserSelect

A component that renders [User](../ai.botstacks.sdk.state/-user/index.md)'s in a horizontally scrolling Row. This is primarily used in CreateChannelView for showing currently selected [User](../ai.botstacks.sdk.state/-user/index.md)s and allowing the ability to add more if desired.

#### Parameters

common

| | |
|---|---|
| modifier | The modifier to apply to this component |
| selectedUsers | Currently selected users |
| canRemove | If enabled, currently selected users can be removed on click (Will trigger [onRemove](-user-select.md). |
| showAdd | If enabled, a trailing add option will appear allowing you to handle [onAddSelected](-user-select.md) to navigate to another view to add users. @see SelectChannelUsers for a use case. |
| onRemove | callback for when a user is removed. |
| onAddSelected | callback when the trailing add option is clicked; requires [showAdd](-user-select.md) to be true. |
